(function () {
    'use strict';

    var prefersReducedMotion = window.matchMedia('(prefers-reduced-motion: reduce)');

    function closestAccordionItem(element) {
        return element.closest('.aeo-accordion-item');
    }

    function cleanupTransition(panel) {
        if (panel._aeoTransitionHandler) {
            panel.removeEventListener('transitionend', panel._aeoTransitionHandler);
            panel._aeoTransitionHandler = null;
        }
        panel.style.height = '';
        panel.style.opacity = '';
    }

    function animatePanel(panel, expand) {
        cleanupTransition(panel);

        if (expand) {
            panel.removeAttribute('hidden');
            panel.style.height = '0px';
            panel.style.opacity = '0';

            requestAnimationFrame(function () {
                panel.style.height = panel.scrollHeight + 'px';
                panel.style.opacity = '1';
            });

            panel._aeoTransitionHandler = function (event) {
                if (event.propertyName === 'height') {
                    cleanupTransition(panel);
                    panel.style.height = 'auto';
                }
            };
            panel.addEventListener('transitionend', panel._aeoTransitionHandler);
        } else {
            panel.style.height = panel.scrollHeight + 'px';
            panel.style.opacity = '1';

            requestAnimationFrame(function () {
                panel.style.height = '0px';
                panel.style.opacity = '0';
            });

            panel._aeoTransitionHandler = function (event) {
                if (event.propertyName === 'height') {
                    panel.setAttribute('hidden', '');
                    cleanupTransition(panel);
                }
            };
            panel.addEventListener('transitionend', panel._aeoTransitionHandler);
        }
    }

    function setExpanded(btn, expand) {
        btn.setAttribute('aria-expanded', expand ? 'true' : 'false');
        var targetId = btn.getAttribute('aria-controls');
        var panel = document.getElementById(targetId);
        if (!panel) { return; }

        var item = closestAccordionItem(btn);
        if (item) {
            item.classList.toggle('is-open', expand);
        }

        if (prefersReducedMotion.matches) {
            cleanupTransition(panel);
            if (expand) {
                panel.removeAttribute('hidden');
            } else {
                panel.setAttribute('hidden', '');
            }
            return;
        }

        animatePanel(panel, expand);
    }

    function handleToggle(event) {
        var btn = event.currentTarget;
        var expanded = btn.getAttribute('aria-expanded') === 'true';
        setExpanded(btn, !expanded);
    }

    function bindAccordionTriggers() {
        var triggers = document.querySelectorAll('.aeo-accordion-trigger');
        triggers.forEach(function (trigger) {
            trigger.addEventListener('click', handleToggle);
        });
    }

    document.addEventListener('DOMContentLoaded', bindAccordionTriggers);
})();
