<?php
    /**
     * Plugin Name:       Anslift
     * Description:       Helps create AI-friendly content (Overviews and FAQs) to improve visibility in AI-driven search results.
     * Version:           1.0.0
     * Author:            AEO GEO RANK
     * Author URI:        https://aeogeorank.com/
     * License:           GPL v2 or later
     * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
     * Requires at least: 6.0
     * Requires PHP:      7.4
     * Text Domain:       anslift
     * Domain Path:       /languages
     */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}

// Define plugin constants for easy path management
define( 'AEO_PLUGIN_VERSION', '1.0.0' );
define( 'AEO_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'AEO_PLUGIN_URL', plugin_dir_url( __FILE__ ) );


/**
 * Translations: Since WordPress 4.6+, translations for plugins hosted on
 * WordPress.org are loaded automatically based on the Text Domain header.
 * No need to call load_plugin_textdomain().
 */
// Intentionally left blank to avoid discouraged load_plugin_textdomain() call.

/**
 * The code that runs during plugin activation.
 */
function aeo_plugin_activate() {
    // Initialize auto insert options (defaults enabled) if not already set
    $legacy_auto_insert = get_option( 'aeo_auto_insert', null );
    if ( $legacy_auto_insert === null ) {
        add_option( 'aeo_auto_insert', 1 ); // 1 = enabled
        $legacy_auto_insert = 1;
    }

    $legacy_enabled = (int) $legacy_auto_insert === 1;

    if ( get_option( 'aeo_auto_insert_summary', null ) === null ) {
        add_option( 'aeo_auto_insert_summary', $legacy_enabled ? 1 : 0 );
    }

    if ( get_option( 'aeo_auto_insert_faqs', null ) === null ) {
        add_option( 'aeo_auto_insert_faqs', $legacy_enabled ? 1 : 0 );
    }

    // Initialize auto analyze option (default enabled per requirements)
    if ( get_option( 'aeo_auto_analyze', null ) === null ) {
        add_option( 'aeo_auto_analyze', 1 );
    }

    // Trigger index rebuild on next admin load.
    delete_option( 'aeo_analyzed_index' );
    delete_option( 'aeo_analyzed_index_built' );
}
register_activation_hook( __FILE__, 'aeo_plugin_activate' );

/**
 * Include the necessary plugin files.
 */
require_once AEO_PLUGIN_PATH . 'admin/menu.php';
require_once AEO_PLUGIN_PATH . 'admin/analysis.php';
require_once AEO_PLUGIN_PATH . 'admin/editor-api.php';
require_once AEO_PLUGIN_PATH . 'admin/improvements.php';
require_once AEO_PLUGIN_PATH . 'admin/cleanup.php';
require_once AEO_PLUGIN_PATH . 'admin/seo.php';
require_once AEO_PLUGIN_PATH . 'includes/frontend.php';

/**
 * Ensure new auto insert options exist for legacy installs.
 */
function aeo_ensure_auto_insert_options() {
    $summary_option = get_option( 'aeo_auto_insert_summary', null );
    $faqs_option    = get_option( 'aeo_auto_insert_faqs', null );

    if ( $summary_option !== null && $faqs_option !== null ) {
        return;
    }

    $legacy = get_option( 'aeo_auto_insert', 1 );
    $enabled = (int) $legacy === 1;

    if ( $summary_option === null ) {
        add_option( 'aeo_auto_insert_summary', $enabled ? 1 : 0 );
    }

    if ( $faqs_option === null ) {
        add_option( 'aeo_auto_insert_faqs', $enabled ? 1 : 0 );
    }
}
add_action( 'plugins_loaded', 'aeo_ensure_auto_insert_options' );

/**
 * Keep legacy aggregate option in sync for backwards compatibility.
 */
function aeo_sync_legacy_auto_insert_option() {
    $summary_enabled = (int) get_option( 'aeo_auto_insert_summary', 1 ) === 1;
    $faqs_enabled    = (int) get_option( 'aeo_auto_insert_faqs', 1 ) === 1;

    $legacy_value = ( $summary_enabled && $faqs_enabled ) ? 1 : 0;
    update_option( 'aeo_auto_insert', $legacy_value );
}


// Ensure uninstall cleanup of custom options (handled in uninstall.php)
