<?php
/**
 * SEO Analysis Sidebar for Gutenberg
 */

if ( ! defined( 'WPINC' ) ) { die; }

/**
 * Enqueue the SEO sidebar assets for the block editor.
 */
function aeo_enqueue_seo_sidebar_assets() {
    // Only load on post editing screens
    $screen = get_current_screen();
    if ( ! $screen || 'post' !== $screen->post_type ) {
        return;
    }

    // Enqueue the script
    wp_enqueue_script(
        'aeo-seo-sidebar',
        AEO_PLUGIN_URL . 'admin/assets/seo-sidebar.js',
        array( 'wp-plugins', 'wp-edit-post', 'wp-element', 'wp-components', 'wp-data', 'wp-compose' ),
        AEO_PLUGIN_VERSION,
        true
    );

    // Enqueue the styles
    wp_enqueue_style(
        'aeo-seo-sidebar',
        AEO_PLUGIN_URL . 'admin/assets/seo-sidebar.css',
        array(),
        AEO_PLUGIN_VERSION
    );

    // Pass data to the script
    wp_localize_script( 'aeo-seo-sidebar', 'aeoSeoData', array(
        'siteUrl' => home_url(),
    ) );
}
add_action( 'enqueue_block_editor_assets', 'aeo_enqueue_seo_sidebar_assets' );
